
function [outI1, outI2, A1, A2] = colourSAugment(I1,I2,A1,A2, satStdDev)
%COLOURAUGMENT Recolour both images independently by 
% shifting the RGB channels a random amount sampled from gaussian

% I1 and I2 are 3-channel images (RGB)
% A1 and A2 are the annotations (YOLO bounding boxes)
    HSV1 = rgb2hsv(I1);
    HSV2 = rgb2hsv(I2);
    HSV1(:,:,2) = imadd(HSV1(:,:,2), normrnd(0, satStdDev));
    HSV2(:,:,2) = imadd(HSV2(:,:,2), normrnd(0, satStdDev));
    outI1 = uint8(hsv2rgb(HSV1)*255);
    outI2 = uint8(hsv2rgb(HSV2)*255);
    outI1 = applyMask(outI1, I1);
    outI2 = applyMask(outI2, I2);
end

